/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.summoningrituals.recipe;

import com.almostreliable.summoningrituals.recipe.AltarRecipe;
import com.almostreliable.summoningrituals.recipe.component.BlockReference;
import com.almostreliable.summoningrituals.recipe.component.IngredientStack;
import com.almostreliable.summoningrituals.recipe.component.RecipeOutputs;
import com.almostreliable.summoningrituals.recipe.component.RecipeSacrifices;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.jetbrains.annotations.Nullable;

public class AltarRecipeSerializer
extends ForgeRegistryEntry<RecipeSerializer<?>>
implements RecipeSerializer<AltarRecipe> {
    public AltarRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
        Ingredient catalyst = Ingredient.m_43917_((JsonElement)json.getAsJsonObject("catalyst"));
        AltarRecipe.CATALYST_CACHE.add(catalyst);
        RecipeOutputs outputs = RecipeOutputs.fromJson(json.getAsJsonArray("outputs"));
        NonNullList inputs = NonNullList.m_122779_();
        if (json.has("inputs")) {
            JsonElement inputJson = json.get("inputs");
            if (inputJson.isJsonObject()) {
                inputs.add((Object)IngredientStack.fromJson(inputJson));
            } else {
                for (JsonElement input : inputJson.getAsJsonArray()) {
                    inputs.add((Object)IngredientStack.fromJson((JsonElement)input.getAsJsonObject()));
                }
            }
        }
        RecipeSacrifices sacrifices = new RecipeSacrifices();
        if (json.has("sacrifices")) {
            sacrifices = RecipeSacrifices.fromJson(json.getAsJsonObject("sacrifices"));
        }
        int recipeTime = GsonHelper.m_13824_((JsonObject)json, (String)"recipe_time", (int)100);
        BlockReference blockBelow = null;
        if (json.has("block_below")) {
            blockBelow = BlockReference.fromJson(json.getAsJsonObject("block_below"));
        }
        AltarRecipe.DAY_TIME dayTime = AltarRecipe.DAY_TIME.valueOf(GsonHelper.m_13851_((JsonObject)json, (String)"day_time", (String)AltarRecipe.DAY_TIME.ANY.name()).toUpperCase());
        AltarRecipe.WEATHER weather = AltarRecipe.WEATHER.valueOf(GsonHelper.m_13851_((JsonObject)json, (String)"weather", (String)AltarRecipe.WEATHER.ANY.name()).toUpperCase());
        return new AltarRecipe(recipeId, catalyst, outputs, (NonNullList<IngredientStack>)inputs, sacrifices, recipeTime, blockBelow, dayTime, weather);
    }

    @Nullable
    public AltarRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        Ingredient catalyst = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        RecipeOutputs outputs = RecipeOutputs.fromNetwork(buffer);
        NonNullList inputs = NonNullList.m_122779_();
        int inputCount = buffer.m_130242_();
        for (int i = 0; i < inputCount; ++i) {
            inputs.add((Object)IngredientStack.fromNetwork(buffer));
        }
        RecipeSacrifices sacrifices = new RecipeSacrifices();
        if (buffer.readBoolean()) {
            sacrifices = RecipeSacrifices.fromNetwork(buffer);
        }
        int recipeTime = buffer.readInt();
        BlockReference blockBelow = null;
        if (buffer.readBoolean()) {
            blockBelow = BlockReference.fromNetwork(buffer);
        }
        AltarRecipe.DAY_TIME dayTime = AltarRecipe.DAY_TIME.values()[buffer.m_130242_()];
        AltarRecipe.WEATHER weather = AltarRecipe.WEATHER.values()[buffer.m_130242_()];
        return new AltarRecipe(recipeId, catalyst, outputs, (NonNullList<IngredientStack>)inputs, sacrifices, recipeTime, blockBelow, dayTime, weather);
    }

    public void toNetwork(FriendlyByteBuf buffer, AltarRecipe recipe) {
        recipe.getCatalyst().m_43923_(buffer);
        recipe.getOutputs().toNetwork(buffer);
        buffer.m_130130_(recipe.getInputs().size());
        for (IngredientStack input : recipe.getInputs()) {
            input.toNetwork(buffer);
        }
        if (recipe.getSacrifices().isEmpty()) {
            buffer.writeBoolean(false);
        } else {
            buffer.writeBoolean(true);
            recipe.getSacrifices().toNetwork(buffer);
        }
        buffer.writeInt(recipe.getRecipeTime());
        if (recipe.getBlockBelow() != null) {
            buffer.writeBoolean(true);
            recipe.getBlockBelow().toNetwork(buffer);
        } else {
            buffer.writeBoolean(false);
        }
        buffer.m_130130_(recipe.getDayTime().ordinal());
        buffer.m_130130_(recipe.getWeather().ordinal());
    }
}

